<!DOCTYPE html>
<html>

<head>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe" crossorigin="anonymous"></script>
  <?php
  // include 'connect.php';
  session_start();
  ?>
  <script>
    function submitted(event) {
      event.preventDefault();
      document.getElementById("inputAlt").removeAttribute('required');
      document.getElementById("inputCrit").removeAttribute('required');
      document.getElementById("myForm").submit();
    }
  </script>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Lato', sans-serif;
      font-family: 'Oswald', sans-serif;
    }

    .wrapper {
      position: fixed;
      top: 0;
      right: -100%;
      height: 100%;
      width: 100%;
      background: #000;
      transition: all 0.6s ease-in-out;
      text-align: center;
    }

    #active:checked~.wrapper {
      right: 0;
    }

    .menu-btn {
      position: absolute;
      z-index: 2;
      right: 20px;
      top: 20px;
      height: 50px;
      width: 50px;
      text-align: center;
      line-height: 50px;
      border-radius: 50%;
      font-size: 20px;
      cursor: pointer;
      transition: all 0.3s ease-in-out;
    }

    .menu-btn span,
    .menu-btn:before,
    .menu-btn:after {
      content: "";
      position: absolute;
      top: 20%;
      left: 30%;
      width: 40%;
      border-bottom: 2px solid #fff;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .menu-btn:before {
      transform: translateY(-8px);
    }

    .menu-btn:after {
      transform: translateY(8px);
    }


    .close {
      z-index: 1;
      width: 100%;
      height: 100%;
      pointer-events: none;
      transition: background .6s;
    }

    /* closing animation */
    #active:checked+.menu-btn span {
      transform: scaleX(0);
    }

    #active:checked+.menu-btn:before {
      transform: rotate(45deg);
      border-color: #fff;
    }

    #active:checked+.menu-btn:after {
      transform: rotate(-45deg);
      border-color: #fff;
    }

    .wrapper ul {
      position: absolute;
      top: 60%;
      left: 50%;
      height: 90%;
      transform: translate(-50%, -50%);
      list-style: none;
      text-align: center;
    }

    .wrapper ul li {
      height: 10%;
      margin: 15px 0;
      text-align: center;
    }

    .wrapper ul li a {
      text-decoration: none;
      font-size: 30px;
      font-weight: 500;
      padding: 5px 30px;
      color: #fff;
      border-radius: 50px;
      position: absolute;
      line-height: 50px;
      margin: 5px 30px;
      opacity: 0;
      transition: all 0.3s ease;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .wrapper ul li a:after {
      position: absolute;
      content: "";
      background: #fff;
      width: 100%;
      height: 100%;
      left: 0;
      top: 0;
      border-radius: 50px;
      transform: scaleY(0);
      z-index: -1;
    }

    .wrapper ul li a:hover:after {
      transform: scaleY(1);
    }

    .wrapper ul li a:hover {
      color: #1a73e8;
    }

    input[type="checkbox"] {
      display: none;
    }

    .content {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      z-index: -1;
      text-align: center;
      width: 100%;
      color: #202020;
    }

    .content .title {
      font-size: 40px;
      font-weight: 600;
    }

    .content p {
      font-size: 35px;
      font-weight: 500;
    }

    #active:checked~.wrapper ul li a {
      opacity: 1;
    }

    .wrapper ul li a {
      transition: opacity 1.2s, transform 1.2s cubic-bezier(0.215, 0.61, 0.355, 1);
      transform: translateX(100px);
    }

    #active:checked~.wrapper ul li a {
      transform: none;
      transition-timing-function: ease, cubic-bezier(.1, 1.3, .3, 1);
      /* easeOutBackを緩めた感じ */
      transition-delay: .6s;
      transform: translateX(-100px);
    }

    .custom-badge {
      width: 200px;
      /* Adjust the width as needed */
      height: 50px;
      /* Adjust the height as needed */
      font-size: 50px;
    }

    .nav-item {
      font-size: 20px;
    }

    .navbar-brand {
      font-size: 17px;
    }
  </style>
  <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Lato&display=swap" rel="stylesheet">
  <script src="https://kit.fontawesome.com/a076d05399.js"></script>
</head>

<body>
  <nav class="navbar navbar-expand-sm bg-dark navbar-dark">
    <div class="container-fluid">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link active" href="">RANKING</a>
        </li>
      </ul>
    </div>
  </nav>
  <input type="checkbox" id="active">
  <label for="active" class="menu-btn"><span></span></label>
  <label for="active" class="close"></label>
  <div class="wrapper">
    <ul>
      <span class="custom-badge">PICK METHOD:</span>
      <li><a href="saw.php">SAW</a></li>
      <li><a href="topsis.php">TOPSIS</a></li>
    </ul>
  </div>
  <div class="container">
    <!-- Input jumlah alternatif dan kriteria -->
    <form method="post" id="myForm">
      <div class="row">
        <div class="col-lg-9">
          <div class="row">
            <h2> Create Template for TOPSIS Method </h2>
            <div class="col-lg-3">
              <!-- Input jumlah alternatif -->
              <label for="inputAlt">Jumlah Alternatif</label><br>
              <input required id="inputAlt" type="number" min="2" name="numAlt" class='form-control'>
            </div>
            <div class="col-lg-1"></div>
            <div class="col-lg-3">
              <!-- Input jumlah kriteria -->
              <label for="inputCrit">Jumlah Kriteria</label><br>
              <input required id="inputCrit" type="number" min="2" name="numCrit" class='form-control'>
            </div>
            <div class="col-lg-1"></div>
          </div>

        </div>
        <h6><br></h6>
        <div class="col-lg-9">
          <!-- Submit -->
          <button class="btn btn-primary btn-lg" type="submit" onclick="submitted()">Submit</button>
          <!-- Reset -->
          <a class="btn btn-danger btn-lg" href="reset.php">Reset</a>
        </div>

        <div>
          <br>
          <br>
          <h5>Or upload a CSV file</h5>
          <a class='btn btn-secondary btn-lg' href='uploadcsv.php'>Upload CSV</a>
        </div>
      </div>
    </form>

    <br>

    <?php
    // Kalo udah submit
    if (isset($_POST["numAlt"]) && isset($_POST["numCrit"])) {
      $alternatives = $_POST['numAlt'];
      $criterias = $_POST['numCrit'];
      
      // Generate the table with input fields
      echo "<form method='POST' action='saveprocess.php?alternatif=" . $alternatives . "&kriteria=" . $criterias . "'>";
      echo '<label for="nama">Template Name: </label>';
      echo '<input type="text" id="nama" name="nama" required>';

      // Buat tabel
      $baris = $_POST['numAlt'] + 1;
      $kolom = $_POST['numCrit'] + 1;
      echo "<table class='table table-bordered table-striped'>";
      for ($i = 1; $i <= $baris; $i++) {
        echo "<tr>";
        for ($j = 1; $j <= $kolom; $j++) {
          if ($i == 1 && $j > 1) { // Judul kolom kriteria
            $temp = $j;
            echo "<th><input id='krit' required type='text' class='form-control' name='cell[$i][$j]' value='' placeholder='Kriteria " . ($temp - 1) . "'><br><input id='kritBobot' required type='number' step='any' class='form-control' name='cell1[$i][$j]' value='' placeholder='Bobot " . ($temp - 1) . "'min='0'></th>";
          } elseif ($i == 1 && $j == 1) { // Kolom pojok kiri atas
            echo "<th></th>";
          } elseif ($i > 1 && $j == 1) { // Input alternatif
            $temp = $i;
            // echo "<td ><input required type='text' class='form-control' name='loc[$i]' value='' placeholder='Location " . ($temp - 1) . "'></td>";
            echo "<td ><input required type='text' class='form-control' name='cell[$i][$j]' value='' placeholder='Alternatif " . ($temp - 1) . "'><br><input required type='text' class='form-control' name='loc[$i]' value='' placeholder='Location " . ($temp - 1) . "'></th>";
          } else { // Input nilai kriteria
            echo "<td ><input required type='number' step='any' class='form-control' name='cell[$i][$j]' value='' min='0'></td>";
          }
        }
        echo "</tr>";
      }
      echo "</table>";
      echo "<br>";
      echo "<button type='submit' value='Submit' class='btn btn-primary btn-lg'>CALCULATE</button>";
      echo "</form>";
    } ?>



  </div>
  <br>
  <br>
  <br>
  <nav class="navbar navbar-expand-sm bg-light navbar-light fixed-bottom justify-content-center">
    <div class="navbar-brand">
      <a>© 2024</a>
    </div>
  </nav>
</body>

</html>